/*------------------------------------------------------------------------------*
 * File Name: ParameterDlg.h					 								*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 *	Hong 01/30/08 QA80-10929 IMPLEMENT_NLFIT_BUTTONS							*
 *	Hong 02/01/08 v8.0798 FIX_REPLICA_FAIL_DISPLAY_IN_LT_NLFIT_PARA_DIALOG		*
 *	Jasmine 04/02/08 RESTRICT_PARAM_DLG_MIN_WIDTH								*
 *	Folger 04/24/08 CENTRALIZE_CODE_OF_SET_FIX_AND_SHARE_PARAMETERS				*
 *	Folger 04/29/08 QA80-11479 ADD_HIDE_BUTTON_IN_NANOSIZER						*
 *	Folger 04/30/08 QA80-11479 ADD_HIDE_BUTTON_FOR_PA							*
 *	Folger 06/12/08 UPDATE_CONTEXT_HELP_FOR_PA_FIT_CONTROL_AND_THEME_SETTING	*
 *	Kyle 09/05/08 USE_NEW_NLFSESSION_AND_NLFPARAMSCONTROL_IN_NLFPARAMDLG		*
 *	Kyle 09/10/08 CHANGE_PROTOTYPE_OF_HIDEPARAMROWS_AND_REMOVE_SETPARAMROWSSHOW	*
 *	Kyle 09/10/08 CLEAN_CODE_TO_USE_NEW_STYLE									*
 *	Folger 10/16/08 PA_FIT_CONTROL_DIALOG_NEED_TO_REMEBERE_AUTO_INIT_CHECKBOX_STATUS
 *	Jasmine 10/17/08 QA80-12401 QUICK_SET_ONE_PARAM_VALUE_TO_ALL				*
 *	Kyle 10/21/08 QA80-12401 QUICK_SET_ONE_PARAM_VALUE_TO_ALL					*
 *	Folger 10/24/08 v8.0960 SUPPORT_SORT_MULTIPLE_PEAKS_IN_PA					*
 *	Sophy 10/30/08 QA80-12425 CUSTOMIZATION_PARAMETER_TAB						*
 *	Folger 11/01/08 QA80-12509 v8.0964 SUPPORT_PEAK_LABEL_SWITCHING_IN_PA_FIT_CONTROL_DIALOG
 *	Kyle 11/04/2008 QUICK_SET_PARAMETERS_VALUE_CHANGE							*
 *	Folger 11/05/08 QA80-12509 v8.0965 SUPPORT_BOTH_PEAKS_SORTING_AND_REORDERING_FOR_MULTIPLE_PEAKS_FITTING
 *	Folger 11/06/08 v8.0966 ENLARGE_PARAMETER_DIALOG_MINIMUM_SIZE				*
 *	Folger 11/15/08 CLICK_GRID_BUTTON_ON_BOUNDS_SHOULD_INVOKE_AFTER_EDIT		*
 *	Sophy 12/2/2008 v8.981b UPDATE_OK_BUTTON_AND_RELATIVE_FIT_BUTTONS_ON_ERROR	*
 *	Folger 12/04/08 v8.0982b AVOID_HARD_CODED_MININUM_WIDTH_IN_FIT_PRARMETER_DIALOG
 *	Sophy 12/4/2008 v8.0982b NOT_ALLOW_EDIT_PEAK_TYPE_COLUMN_AS_PARAM_NAME_COLUMN
 *	Hong QA80-12730 v8.0983b IMRPOVE_HIDE_DLG_WITH_HIDE_BY_GROUP				*
 *	Hong 12/09/08 QA80-12744 PA_PARAMS_DLG_ADD_FUNC_PREVIEW_TABS				*
 *	Hong 12/10/08 QA80-12744 IMPROVE_PARAM_GRID_BY_ROW_SEL_AND_BOLD_ACTVIE_CELL	*
 *	Hong 12/10/08 v8.0984d ADD_APPLY_TO_ALL_FOR_SIGNIFICANT_DIGITS				*
 *	Hong 12/11/08 v8.0985 FIX_DLG_INIT_HEIGHT_TOO_SAMLL_AFTER_ADD_FUNC_PREVIEW_TAB
 *	Folger 12/11/08 v8.0985 SUPPORT_DOUBLE_CLICK_TO_SWICH_BOUND_CONTROL			*
 *	Folger 12/15/08 v8.0986c PARAMETER_GRID_RUNTIME_ERROR_WHEN_CHANGE_FIX_STATUS_THEN_FIT
 *	Folger 01/05/09 v8.0993d REMEMBER_HIDE_GETN_DIALOG_STATUS_IN_PARAMETER_DIALOG
 *	Hong 01/21/09 USING_CONTEXT_MENU_APPLY_TO_ALL_TO_REPLACE_QUICK_SET_BTN		*
 *	Hong 01/22/09 NO_APPLY_TO_ALL_IF_SINGLE_SET_NO_REPLICA_IN_NLFIT				*
 *	Kyle 01/23/2009 SHOW_TOOLTIP_WHEN_MOUSE_MOVED_ON_BOUNDS_CONTROL				*
 *	Hong 01/23/09 MORE_PRECISE_BOUND_CLEAR_AND_RESET_CONTEXT_MENU				*
 *  Iris 2/05/2009 FIX_HIDE_PARAM_DLG_TITLE_TOO_LONG_TO_DISPLAY					*
 *	Folger 02/12/09 IMPROVE_HIDE_PARAM_DIALOG_GUI								*
 *	Folger 03/09/09 PROPER_HANDLE_OF_MAX_NUM_ITERATE_IN_FIT_PARAM_DIALOG		*
 *	Folger 03/05/09 CHANGE_SIGNIFICANT_DIGITS_MAKE_OUTPUT_VALUES_MISSING		*
 *	Folger 03/16/09 PARAMETER_HIDDEN_STATUS_SHOULD_BE_UPDATED_AFTER_PEAKS_CHANGED
 *	Folger 04/20/09 F1_HELP_MAPPING_ON_HIDE_PARAM_DIALOG_IN_NLFIT_AND_PA		*
 *	Folger 07/14/09 NANOSIZER_FAILS_TO_UPDATE_PARAMETERS_HIDE_GUI_AFTER_CHANGE_FUNCTION
 *------------------------------------------------------------------------------*/

#ifndef _NL_FITTING_H_
#define _NL_FITTING_H_

#include <xfgraph_utils.h>			/// Kyle 09/05/08 USE_NEW_NLFSESSION_AND_NLFPARAMSCONTROL_IN_NLFPARAMDLG

enum{PF_PARAMETERS_TAB, PF_PARABOUND_TAB};

///Sophy, Should be centralize with nlfitdlg
#define	WM_USER_SELECT_TOP_TAB			(WM_USER + 1300)	///Sophy 10/30/08 QA80-12425 CUSTOMIZATION_PARAMETER_TAB
#include "ParameterTabs.h"			///Sophy 10/30/08 QA80-12425 CUSTOMIZATION_PARAMETER_TAB
/// Hong 12/09/08 QA80-12744 PA_PARAMS_DLG_ADD_FUNC_PREVIEW_TABS
#include <ocGDI.h>
#include "FOFunctPrev.h"
/// end PA_PARAMS_DLG_ADD_FUNC_PREVIEW_TABS

/// Hong 12/09/08 QA80-12744 PA_PARAMS_DLG_ADD_FUNC_PREVIEW_TABS
enum {PF_MESSAGES, PF_FORMULA_TAB, PF_SAMPLE_CURVE_TAB, PF_FUNCTION_FILE_TAB};
/// end PA_PARAMS_DLG_ADD_FUNC_PREVIEW_TABS

class FitParaDlg : public MultiPaneDlg
{
public:
	FitParaDlg() : MultiPaneDlg(IDD_PFM_FIT_DLG, "ODlg8")
	{
		m_bShowAdvBtn = false;
		m_nMinWidth = 750;		//------ Folger 12/04/08 v8.0982b AVOID_HARD_CODED_MININUM_WIDTH_IN_FIT_PRARMETER_DIALOG
	}
	~FitParaDlg()
	{
		///Sophy 10/7/2008 RESET_LOG_PONITER_WHEN_CLICK_UNDO_WITH_PARAMDLG_OPEN
		m_pNLFitSession->UnlinkMsgLog();
		///end RESET_LOG_PONITER_WHEN_CLICK_UNDO_WITH_PARAMDLG_OPEN
	}
	int Create(HWND hWndParent = NULL)
	{
		InitMsgMap();
		int nRet = MultiPaneDlg::Create(hWndParent);
		Visible = true;
		return nRet;
	}
	///Sophy 12/2/2008 v8.981b UPDATE_OK_BUTTON_AND_RELATIVE_FIT_BUTTONS_ON_ERROR
	virtual void EnableOKButton(bool bEnable);
	///end UPDATE_OK_BUTTON_AND_RELATIVE_FIT_BUTTONS_ON_ERROR

protected :	
EVENTS_BEGIN
	ON_INIT(OnInitDialog) 
	ON_DESTROY(OnDestroy)
	ON_READY(OnReady)
	ON_SIZE(OnDlgResize)
	ON_INIT_SIZE(OnInitSize)
	ON_RESTORESIZE(OnRestoreSize)
	
	ON_CHANGE_PAGE(OnActivePageChange)
	
	///Jasmine 04/02/08 RESTRICT_PARAM_DLG_MIN_WIDTH
	ON_SYSCOMMAND(OnSystemCommand)
	ON_GETMINMAXINFO(OnMinMaxInfo)
	///End RESTRICT_PARAM_DLG_MIN_WIDTH
	
	ON_BN_CLICKED(IDOK, OnClickOK)
	ON_BN_CLICKED(IDC_PF_AVANCED, OnAdvanced)
	ON_BN_CLICKED(IDC_PF_INIT, OnInitParamValue)
	ON_BN_CLICKED(IDC_PF_ONE_LTER, OnClickOneIter)
	ON_BN_CLICKED(IDC_PF_FIT, OnClickFit)	
	
	ON_CONTEXTMENU(OnShowMenu)	///Sophy 10/30/08 QA80-12425 CUSTOMIZATION_PARAMETER_TAB
	ON_USER_MSG(WM_USER_SELECT_TOP_TAB, SelTopTab) ///Sophy 10/30/08 QA80-12425 CUSTOMIZATION_PARAMETER_TAB
	
	/// Hong 01/30/08 QA80-10929 IMPLEMENT_NLFIT_BUTTONS
	ON_BN_CLICKED(IDC_PF_CHI_SQ, OnClickChiSQ)
	ON_BN_CLICKED(IDC_PF_SIMPLX, OnClickSimplex)
	/// end IMPLEMENT_NLFIT_BUTTONS
	ON_BN_CLICKED(IDC_PF_HIDE, OnClickParamHide) 
	ON_BN_CLICKED(IDC_PF_QUICK_SET, OnQuickSetParam) 	///Jasmine 10/17/08 QA80-12401 QUICK_SET_ONE_PARAM_VALUE_TO_ALL

	///Jasmine 04/09/08 ADD_FIX_RELEASE_BUTTONS	
	ON_BN_CLICKED(IDC_PF_FIXED_BASELINE, OnToggleFixBaseline)
	ON_BN_CLICKED(IDC_PF_FIXED_CENTER, OnToggleFixPeakCenter)
	ON_BN_CLICKED(IDC_PF_FIXED_WIDTH, OnToggleFixPeakWidth)
	///End ADD_FIX_RELEASE_BUTTONS
	
	//------ Folger 04/24/08 CENTRALIZE_CODE_OF_SET_FIX_AND_SHARE_PARAMETERS
	ON_BN_CLICKED(IDC_PF_SHARED_WIDTH, OnToggleSharePeakWidth)
	//------
	
	ON_BN_CLICKED(IDC_PF_SORT_PEAKS, OnSortPeaks)		//------ Folger 10/24/08 v8.0960 SUPPORT_SORT_MULTIPLE_PEAKS_IN_PA
	
	//------ Folger 11/05/08 QA80-12509 v8.0965 SUPPORT_BOTH_PEAKS_SORTING_AND_REORDERING_FOR_MULTIPLE_PEAKS_FITTING
	ON_BN_CLICKED(IDC_PF_REORDER_PEAKS, OnReorderPeaks)
	//------
	
	ON_BN_CLICKED(IDC_PF_SWITCH_PEAK_LABEL, OnSwitchPeakLabel)		//------ Folger 11/01/08 QA80-12509 v8.0964 SUPPORT_PEAK_LABEL_SWITCHING_IN_PA_FIT_CONTROL_DIALOG
	
	ON_BN_CLICKED(IDC_PF_AUTO_INIT_CHECK, OnCheckAutoInit)
	
	ON_TAB_SEL_CHANGE(IDC_PF_SETTING_TAB, OnTopTabChange)
	/// Hong 12/09/08 QA80-12744 PA_PARAMS_DLG_ADD_FUNC_PREVIEW_TABS
	ON_TAB_SEL_CHANGE(IDC_PF_VIEW_TAB, OnBottomTabChange)	
	ON_GRID_AFTER_SEL_CHANGE(IDC_PF_PARA_GRID, OnAfterSelChange)
	/// end PA_PARAMS_DLG_ADD_FUNC_PREVIEW_TABS
	
	ON_BN_CLICKED(IDC_SHOW_BOTTOM, OnShowBottomPane)
	
	ON_GRID_BEFORE_EDIT(IDC_PF_PARA_GRID, OnBeforeEditParaControl)
	ON_GRID_AFTER_EDIT(IDC_PF_PARA_GRID, OnAfterEditParaControl)
	ON_GRID_BEFORE_MOUSE_DOWN(IDC_PF_PARA_GRID, OnBeforeMouseDownParaControl)
	ON_GRID_MOUSE_MOVE(IDC_PF_PARA_GRID, OnMouseMoveParaControl)
	ON_GRID_COMBO_CLOSEUP(IDC_PF_PARA_GRID, OnGridComboCloseUp)

	//------ Folger 12/11/08 v8.0985 SUPPORT_DOUBLE_CLICK_TO_SWICH_BOUND_CONTROL
	//ON_GRID_BUTTON_CLICK(IDC_PF_PARA_GRID, OnGridButtonClick)			/// Kyle 09/08/08 USE_NEW_NLFSESSION_AND_NLFPARAMSCONTROL_IN_NLFPARAMDLG
	ON_GRID_DBLCLICK(IDC_PF_PARA_GRID, OnGridDBClick)
	//------ End SUPPORT_DOUBLE_CLICK_TO_SWICH_BOUND_CONTROL
	
	ON_CBN_SELCHANGE(IDC_PF_COMBO, OnComboChangeFunction)
	
	ON_HELPINFO(OnHelp)		//------ Folger 06/12/08 UPDATE_CONTEXT_HELP_FOR_PA_FIT_CONTROL_AND_THEME_SETTING
	
	ON_USER_MSG(WM_USER_NLF_QUICK_SET_PARAMETER_VALUE_CHANGE, OnQuickSetParameterChange)		/// Kyle 11/04/2008 QUICK_SET_PARAMETERS_VALUE_CHANGE
	
	ON_USER_MSG(WM_USER_NLF_RESET_BOUNDS, OnResetParamBounds) /// Hong 01/23/09 MORE_PRECISE_BOUND_CLEAR_AND_RESET_CONTEXT_MENU
	
	///Jasmine 04/14/10 QA81-15304 ANNOUNCE_FITTING_FUNC_CHANGE
	ON_ORIGIN_MSG(SN_ON_FITTING_FUNCTION_CHANGE, OnFittingFuncChange)
	///End ANNOUNCE_FITTING_FUNC_CHANGE
EVENTS_END
	BOOL	OnQuickSetParameterChange(DWORD wParam, DWORD lParam);		/// Kyle 11/04/2008 QUICK_SET_PARAMETERS_VALUE_CHANGE
	
	BOOL	OnResetParamBounds(DWORD wParam, DWORD lParam); /// Hong 01/23/09 MORE_PRECISE_BOUND_CLEAR_AND_RESET_CONTEXT_MENU

	///Jasmine 04/14/10 QA81-15304 ANNOUNCE_FITTING_FUNC_CHANGE
	virtual BOOL OnFittingFuncChange(uint wParam, uint lParam){return FALSE;}
	///End ANNOUNCE_FITTING_FUNC_CHANGE
	
	//------ Folger 12/11/08 v8.0985 SUPPORT_DOUBLE_CLICK_TO_SWICH_BOUND_CONTROL
	//void OnGridButtonClick(Control flxControl, int nRow, int nCol);		/// Kyle 09/08/08 USE_NEW_NLFSESSION_AND_NLFPARAMSCONTROL_IN_NLFPARAMDLG
	void OnGridDBClick(Control flxControl);
	//------ End SUPPORT_DOUBLE_CLICK_TO_SWICH_BOUND_CONTROL
	
	int	GetTotalWidth(bool bMin = false);	///Jasmine 04/02/08 RESTRICT_PARAM_DLG_MIN_WIDTH
	
	BOOL OnInitDialog();
	//------ Folger 10/16/08 PA_FIT_CONTROL_DIALOG_NEED_TO_REMEBERE_AUTO_INIT_CHECKBOX_STATUS
	//BOOL OnReady();
	virtual BOOL OnReady();
	//------
	BOOL OnDlgResize(int nType, int cx, int cy);
	BOOL OnInitSize();
	BOOL OnRestoreSize(DWORD dwSizeInfo);
	BOOL OnActivePageChange();
	
	BOOL OnClickOK();	
	BOOL OnClickFit(Control ctrl);
	BOOL OnClickOneIter(Control ctrl);
	
	BOOL SelTopTab(int nSel, DWORD dw = 0);				///Sophy 10/30/08 QA80-12425 CUSTOMIZATION_PARAMETER_TAB
	BOOL OnShowMenu(UINT nResIDCtrl, int nx, int ny);	///Sophy 10/30/08 QA80-12425 CUSTOMIZATION_PARAMETER_TAB

	virtual BOOL OnCheckAutoInit(Control ctrl);
	
	/// Hong 01/30/08 QA80-10929 IMPLEMENT_NLFIT_BUTTONS
	virtual BOOL OnClickChiSQ(Control ctrl);
	virtual BOOL OnClickSimplex(Control ctrl);
	/// end IMPLEMENT_NLFIT_BUTTONS
	
	virtual BOOL OnComboChangeFunction(Control cntrl){return FALSE;}
	
	virtual BOOL OnClickParamHide(Control ctrl);
	BOOL OnQuickSetParam(Control ctrl); 	///Jasmine 10/17/08 QA80-12401 QUICK_SET_ONE_PARAM_VALUE_TO_ALL
	
	///Jasmine 04/09/08 ADD_FIX_RELEASE_BUTTONS	
	virtual BOOL OnToggleFixBaseline(Control ctrl){return FALSE;}
	virtual BOOL OnToggleFixPeakCenter(Control ctrl){return FALSE;}
	virtual BOOL OnToggleFixPeakWidth(Control ctrl){return FALSE;}
	///End ADD_FIX_RELEASE_BUTTONS
	
	//------ Folger 04/24/08 CENTRALIZE_CODE_OF_SET_FIX_AND_SHARE_PARAMETERS
	virtual BOOL OnToggleSharePeakWidth(Control ctrl){return FALSE;}
	//------
	
	virtual	BOOL	OnSortPeaks(Control ctrl)		{ return FALSE; }				//------ Folger 10/24/08 v8.0960 SUPPORT_SORT_MULTIPLE_PEAKS_IN_PA
	
	//------ Folger 11/05/08 QA80-12509 v8.0965 SUPPORT_BOTH_PEAKS_SORTING_AND_REORDERING_FOR_MULTIPLE_PEAKS_FITTING
	virtual	BOOL	OnReorderPeaks(Control ctrl)	{ return FALSE; }
	//------
	
	virtual	BOOL	OnSwitchPeakLabel(Control ctrl)		{ return FALSE; }			//------ Folger 11/01/08 QA80-12509 v8.0964 SUPPORT_PEAK_LABEL_SWITCHING_IN_PA_FIT_CONTROL_DIALOG
	
	BOOL OnTopTabChange(Control cntrl);		
	/// Hong 12/09/08 QA80-12744 PA_PARAMS_DLG_ADD_FUNC_PREVIEW_TABS
	BOOL 	OnBottomTabChange(Control cntrl);
	/// Hong 12/10/08 QA80-12744 IMPROVE_PARAM_GRID_BY_ROW_SEL_AND_BOLD_ACTVIE_CELL
	//void 	OnAfterSelChange(Control cntrl, int nOldRowSel, int nOldColSel, int nNewRowSel, int nNewColSel);
	virtual void 	OnAfterSelChange(Control cntrl, int nOldRowSel, int nOldColSel, int nNewRowSel, int nNewColSel);
	/// end IMPROVE_PARAM_GRID_BY_ROW_SEL_AND_BOLD_ACTVIE_CELL
	/// end PA_PARAMS_DLG_ADD_FUNC_PREVIEW_TABS
	///Sophy 12/4/2008 v8.0982b NOT_ALLOW_EDIT_PEAK_TYPE_COLUMN_AS_PARAM_NAME_COLUMN
	//void OnBeforeEditParaControl(Control flxControl, long nRow, long nCol, BOOL* pCancel);
	virtual void OnBeforeEditParaControl(Control flxControl, long nRow, long nCol, BOOL* pCancel);
	///end NOT_ALLOW_EDIT_PEAK_TYPE_COLUMN_AS_PARAM_NAME_COLUMN
	void OnBeforeMouseDownParaControl(Control cntrl, short nButton, short nShift, float X, float Y, BOOL* pCancel);
	void OnMouseMoveParaControl(Control cntrl, short nButton, short nShift, float X, float Y);
	void OnGridComboCloseUp(Control ctrl, int nRow, int nCol, BOOL* pFinishEdit);
	
	//------ Folger 06/12/08 UPDATE_CONTEXT_HELP_FOR_PA_FIT_CONTROL_AND_THEME_SETTING
	virtual	BOOL OnHelp(int &nHelpID, int nIdCtrlFocus)	{return FALSE;}
	//------

protected:	
	/// Hong QA80-12730 v8.0983b IMRPOVE_HIDE_DLG_WITH_HIDE_BY_GROUP
	//bool OpenHideParamRowsBox(TreeNodeCollection & trNs, const vector<int>& vnParamsHide, const vector<string> & vsLabel);	///Kyle 09/10/08 USE_NEW_NLFSESSION_AND_NLFPARAMSCONTROL_IN_NLFPARAMDLG
	///------ Folger 03/16/09 PARAMETER_HIDDEN_STATUS_SHOULD_BE_UPDATED_AFTER_PEAKS_CHANGED
	//bool OpenHideParamRowsBox(TreeNodeCollection & trNs, const vector<int>& vnParamsHide, const vector<string> & vsLabel, int* pnGroupToShow = NULL);	///Kyle 09/10/08 USE_NEW_NLFSESSION_AND_NLFPARAMSCONTROL_IN_NLFPARAMDLG
	bool OpenHideParamRowsBox(TreeNodeCollection & trNs, const vector<int>& vnParamsHide, const vector<string> & vsLabel, int* pnGroupToShow = NULL, bool bShowGetNDialog = true);
	///------ End PARAMETER_HIDDEN_STATUS_SHOULD_BE_UPDATED_AFTER_PEAKS_CHANGED
	/// end IMRPOVE_HIDE_DLG_WITH_HIDE_BY_GROUP
	bool UpdateFitSession();
	bool SetParameterTree(TreeNode& trPara);
	virtual bool IsShowPeakTypeCol(); /// Hong 02/01/08 8.0798 LT_NLFIT_PARA_NO_NEED_PEAK_TYPE_COLUMN
	TreeNode GetParameterTreeFromGrid();
	
	bool fit(int nNumFit=-1, int nMethod = FITMETH_LEVENBERG_MARQUARDT);
	
	virtual BOOL OnDestroy();
	virtual BOOL OnAdvanced(Control ctrl);
	virtual BOOL OnInitParamValue(Control ctrl);
	virtual void OnAfterEditParaControl(Control flxControl, int nRow, int nCol);
	virtual void EnableFitButton(bool bEnable);		
	virtual bool updateParameters(bool bNewGrid = false, int* pnSetting = NULL);	///Jasmine 05/05/08 UPDATE_PEAK_LABEL_PLOT_AFTER_PEAK_CENTER_PARAM_CHANGE	
	
	//------ Folger 11/05/08 QA80-12509 v8.0965 SUPPORT_BOTH_PEAKS_SORTING_AND_REORDERING_FOR_MULTIPLE_PEAKS_FITTING
	void	EnablePeakSortingButton(bool bEnable);
	void	EnablePeakReorderingButton(bool bEnable);
	//------
	
	/// Hong 12/09/08 QA80-12744 PA_PARAMS_DLG_ADD_FUNC_PREVIEW_TABS
	//virtual 
	int GetBottomPaneSubControls(vector<uint>& vnCntrls);
	/// end PA_PARAMS_DLG_ADD_FUNC_PREVIEW_TABS

	virtual	void		ResetParamHideTree();		///------ Folger 07/14/09 NANOSIZER_FAILS_TO_UPDATE_PARAMETERS_HIDE_GUI_AFTER_CHANGE_FUNCTION

public:
	/// Iris/Kyle 09/05/08 USE_NEW_NLFSESSION_AND_NLFPARAMSCONTROL_IN_NLFPARAMDLG, m_pGridParas will call parameter manager pointer to real time update param.
	//bool SetFitSession(NLFitSession* pFitSession);
	bool SetFitSession(NLFitSession* pFitSession);
	///end USE_NEW_NLFSESSION_AND_NLFPARAMSCONTROL_IN_NLFPARAMDLG
	bool SetAdvTree(TreeNode& tr);
	bool GetAdvTree(TreeNode& tr);
	virtual bool Update(bool bNewGrid = false);	
private:
	virtual void updateOnParameterChange( int nUpdateParts );				/// Kyle 11/04/2008 QUICK_SET_PARAMETERS_VALUE_CHANGE
	virtual bool initParaGrid(int nID, Dialog& dlg, LPCSTR lpcszDlgName);
	virtual void updateControlsVisibility();
	virtual void initButtons();
	virtual int getButtonIDs(vector<uint>& vnButtonIDs);
	
	virtual void initAfterUpdate(){}
	
	//virtual TreeNode getParamsSetting(); 
	//virtual bool setParameterTreeToGrid();	 /// Iris 9/05/2008 PA_PARAM_DLG_USE_NEW_FIT_CLASS
	virtual int getParameterGroups();
	virtual int getToltalNumParams(); /// Hong 02/01/08 v8.0798 FIX_REPLICA_FAIL_DISPLAY_IN_LT_NLFIT_PARA_DIALOG
	virtual int getMaxIterationNum();
	virtual bool beforeIterate();
	virtual bool afterIterate(bool bEnable);
	
	/// Hong QA80-12730 v8.0983b IMRPOVE_HIDE_DLG_WITH_HIDE_BY_GROUP
	//virtual	bool	customParamRowsShow(bool bUpdateGird = true);	
	virtual	bool	customParamRowsShow(bool bUpdateGird = true,  int* pnGroupToShow = NULL);
	/// end IMRPOVE_HIDE_DLG_WITH_HIDE_BY_GROUP
	
	virtual bool	updateHiddenParamsInfo();		//------ Folger 04/30/08 QA80-11479 ADD_HIDE_BUTTON_FOR_PA
	
	bool	accessHiddenParamsInfo(vector<int> &vnParamsHide, bool bLoad = true);	//------ Folger 04/29/08 QA80-11479 ADD_HIDE_BUTTON_IN_NANOSIZER
	
	//------ Folger 12/04/08 v8.0982b AVOID_HARD_CODED_MININUM_WIDTH_IN_FIT_PRARMETER_DIALOG
	void	calcMinWidth();
	//------
	/// Hong 12/09/08 QA80-12744 PA_PARAMS_DLG_ADD_FUNC_PREVIEW_TABS
	void	setBottomPaneActiveTab(int nTabToShow = -1);
	void	updateBottomPaneSubControlsShowStatus();
	void	updateBottonTabCtrlSize();
	void	updateBottomTabDisplay(int nTabToUpdate = -1);
	/// end PA_PARAMS_DLG_ADD_FUNC_PREVIEW_TABS
	
	///------ Folger 01/05/09 v8.0993d REMEMBER_HIDE_GETN_DIALOG_STATUS_IN_PARAMETER_DIALOG
	virtual	TreeNode	getParamHideTree(const vector<int>& vnParamsHide, const vector<string> & vsLabel, string* pstrNodePre = NULL, bool bAddGroupShowCombo = false);
	void				updateGroupShowCombo(TreeNode& tr);
	///------ End REMEMBER_HIDE_GETN_DIALOG_STATUS_IN_PARAMETER_DIALOG
	
private:
	TabControl			m_TopTab;	
	int					m_nSelTab;	
	bool				m_bFirstTimeResize;	
	OperationLog		m_OPMsgLog;	
	/// Hong 12/09/08 QA80-12744 PA_PARAMS_DLG_ADD_FUNC_PREVIEW_TABS
	NFPreviewControl	m_NFunctionPrev;
	NFPreviewControl	m_NCurvePrev;
	RichEditEx			m_reditFunctionFile;
	/// end PA_PARAMS_DLG_ADD_FUNC_PREVIEW_TABS
	
	ParamTabs			m_paramTabs;	///Sophy 10/30/08 QA80-12425 CUSTOMIZATION_PARAMETER_TAB
protected:	
	///Kyle 09/05/08 USE_NEW_NLFSESSION_AND_NLFPARAMSCONTROL_IN_NLFPARAMDLG
	//NLFitParamsControl*	m_pGridParas;
	NLFParamsControl *  m_pGridParas;
	///End USE_NEW_NLFSESSION_AND_NLFPARAMSCONTROL_IN_NLFPARAMDLG
	
	///Kyle 09/05/08 USE_NEW_NL_FIT_SESSION
	NLFitSession * 			m_pNLFitSession;
	///End USE_NEW_NL_FIT_SESSION
	
	Tree 				m_trAdvanced;
	string 				m_strDlgName;
	
	bool				m_bShowAdvBtn;
	vector<int> 		m_vnParamsHide;
	int					m_nParamEditBits;
	vector<bool>		m_vbButtonOldStatus;	///Sophy 12/2/2008 v8.981b UPDATE_OK_BUTTON_AND_RELATIVE_FIT_BUTTONS_ON_ERROR
	
	int					m_nMinWidth;		//------ Folger 12/04/08 v8.0982b AVOID_HARD_CODED_MININUM_WIDTH_IN_FIT_PRARMETER_DIALOG
	
	Tree				m_trParamHide;		///------ Folger 01/05/09 v8.0993d REMEMBER_HIDE_GETN_DIALOG_STATUS_IN_PARAMETER_DIALOG
};

///Kyle 11/04/2008 QUICK_SET_PARAMETERS_VALUE_CHANGE
BOOL	FitParaDlg::OnQuickSetParameterChange(DWORD wParam, DWORD lParam)
{
	int nUpdateParts = wParam;
	if(nUpdateParts>0)
		updateOnParameterChange( nUpdateParts );
	return true;
}

void FitParaDlg::updateOnParameterChange( int nUpdateParts )
{
	return;
}
///End QUICK_SET_PARAMETERS_VALUE_CHANGE

/// Hong 01/23/09 MORE_PRECISE_BOUND_CLEAR_AND_RESET_CONTEXT_MENU
BOOL	FitParaDlg::OnResetParamBounds(DWORD wParam, DWORD lParam)
{	
	return m_pNLFitSession->ResetParamBounds(wParam);		
}
/// end MORE_PRECISE_BOUND_CLEAR_AND_RESET_CONTEXT_MENU

///Jasmine 04/02/08 RESTRICT_PARAM_DLG_MIN_WIDTH
int	FitParaDlg::GetTotalWidth(bool bMin)// = false
{
	//------ Folger 11/06/08 v8.0966 ENLARGE_PARAMETER_DIALOG_MINIMUM_SIZE
	//return 600;
	return m_nMinWidth;
	//------
}
///End RESTRICT_PARAM_DLG_MIN_WIDTH

BOOL FitParaDlg::OnInitDialog()
{	
	ShowWindow(SW_HIDE);
	Text = m_strDlgName;
	vector<string>  vstrTipsUpDown;
	vstrTipsUpDown.SetSize(2);
	vstrTipsUpDown[0] = _L("Show More");
	vstrTipsUpDown[1] = _L("Show Less");
	vector<string> vsBottomTabs;
	/// Hong 12/09/08 QA80-12744 PA_PARAMS_DLG_ADD_FUNC_PREVIEW_TABS
	//vsBottomTabs.SetSize(2);
	//vsBottomTabs[0] = _L("Preview");
	//vsBottomTabs[1] = _L("Messages");
	//MultiPaneDlg::OnInitDialog(IDC_PF_SETTING_TAB, IDC_SHOW_BOTTOM, IDC_PF_OPERATION_LOG, vstrTipsUpDown, m_strDlgName, 0, NULL, 0);	
	// Hong, the order below must be consistent with enum PF_MESSAGES
	vsBottomTabs.SetSize(4);
	vsBottomTabs[0] = _L("Messages");
	vsBottomTabs[1] = _L("Formula");
	vsBottomTabs[2] = _L("Sample Curve");
	vsBottomTabs[3] = _L("Function File");
	MultiPaneDlg::OnInitDialog(IDC_PF_SETTING_TAB, IDC_SHOW_BOTTOM, IDC_PF_VIEW_TAB, vstrTipsUpDown, m_strDlgName, 0, vsBottomTabs);
	/// end PA_PARAMS_DLG_ADD_FUNC_PREVIEW_TABS
	
	initButtons();
	updateControlsVisibility();	
	
	m_TopTab = GetItem(IDC_PF_SETTING_TAB);
	///Sophy 10/30/08 QA80-12425 CUSTOMIZATION_PARAMETER_TAB m_paramTabs.Init will load these two tabs
	//m_TopTab.InsertItem(PF_PARAMETERS_TAB, _L("Parameters"));
	//m_TopTab.InsertItem(PF_PARABOUND_TAB, _L("Bounds"));
	///end CUSTOMIZATION_PARAMETER_TAB
	GetItem(IDC_PF_PARA_GRID).Visible = true;
	
	int nEdge = GetControlGap();
	int nTop = nEdge * 2;
	Control chkAutoInit = GetItem(IDC_PF_AUTO_INIT_CHECK);
	if(chkAutoInit.Visible)
	{
		MoveControl(IDC_PF_AUTO_INIT_CHECK, nEdge, nEdge * 2);
		
		RECT rCheck;
		GetClientRect(chkAutoInit, rCheck);
		nTop += RECT_HEIGHT(rCheck) + nEdge;
	}
	MoveControl(IDC_PF_SETTING_TAB, nEdge, nTop);
	
	initParaGrid(IDC_PF_PARA_GRID, *this, m_strDlgName);	
	///Kyle 09/08/08 USE_NEW_NLFSESSION_AND_NLFPARAMSCONTROL_IN_NLFPARAMDLG
	m_pGridParas->SetNLParamsMngr(m_pNLFitSession->GetNLParamsMngr());
	///End USE_NEW_NLFSESSION_AND_NLFPARAMSCONTROL_IN_NLFPARAMDLG
	
	///Sophy 10/30/08 QA80-12425 CUSTOMIZATION_PARAMETER_TAB
	m_paramTabs.Init(m_strDlgName, &m_TopTab, m_pGridParas, 0 );
	///end CUSTOMIZATION_PARAMETER_TAB
	
	m_OPMsgLog.Init(IDC_PF_OPERATION_LOG, *this);
	
	/// Hong 12/09/08 QA80-12744 PA_PARAMS_DLG_ADD_FUNC_PREVIEW_TABS
	m_NFunctionPrev.Init(IDC_PF_FUNC_FORMULA,*this, 0, "");	
	m_NCurvePrev.Init(IDC_PF_FUNC_CURVE,*this, 0, "");	
	m_reditFunctionFile = GetItem(IDC_PF_FUNC_CODE_SHOW);
	m_reditFunctionFile.SetReadOnly();
	m_reditFunctionFile.Visible = false;
	/// end PA_PARAMS_DLG_ADD_FUNC_PREVIEW_TABS
	
	bool bNewGrid = true;
	//----CPY 4/4/08 PA_FIT_CNTRL_OPEN_WITH_RUNTIME_ERR
	if(!Update(bNewGrid))
		return error_report("Dialog cannot be used, some serious error");
	//----
	
	initAfterUpdate();
	
	m_bFirstTimeResize = true;
	m_nSelTab = -1;
	
	//------ Folger 04/29/08 QA80-11479 ADD_HIDE_BUTTON_IN_NANOSIZER
	accessHiddenParamsInfo(m_vnParamsHide, true);
	
	//------ Folger 04/30/08 QA80-11479 ADD_HIDE_BUTTON_FOR_PA
	//int	nTotalParams = getToltalNumParams();
	//if ( m_vnParamsHide.GetSize() != nTotalParams )
	//{
		//m_vnParamsHide.SetSize(nTotalParams);
		//m_vnParamsHide = 0;
	//}
	updateHiddenParamsInfo();
	//------
	
	customParamRowsShow();
	//------
	
	//------ Folger 12/04/08 v8.0982b AVOID_HARD_CODED_MININUM_WIDTH_IN_FIT_PRARMETER_DIALOG
	calcMinWidth();
	//------
	
	return true;
}

BOOL FitParaDlg::OnDestroy()
{
	accessHiddenParamsInfo(m_vnParamsHide, false);		//------ Folger 04/29/08 QA80-11479 ADD_HIDE_BUTTON_IN_NANOSIZER
	
	if(m_pNLFitSession)
		m_pNLFitSession->UnlinkMsgLog(); 	

	m_paramTabs.OnDestroy();		///Sophy 10/30/08 QA80-12425 CUSTOMIZATION_PARAMETER_TAB
	
	if(m_pGridParas)
	{
		m_pGridParas->OnDestroy();
		delete m_pGridParas;
	}

	return MultiPaneDlg::OnDestroy(); 	
}

BOOL FitParaDlg::OnReady()
{	
	UpdateDlgShow();
	SetInitReady();	
	ShowWindow(SW_NORMAL);
	GetItem(IDC_PF_PARA_GRID).Visible = true;	//don't know why the grid is hidden, so show it here
	
	m_pGridParas->SetReady();	///Sophy 10/30/08 QA80-12425 CUSTOMIZATION_PARAMETER_TAB
	
	EnablePeakSortingButton(true);
	EnablePeakReorderingButton(false);
	
	return true;   
}

BOOL FitParaDlg::OnDlgResize(int nType, int cx, int cy)
{
	if(!IsInitReady())
	{
		_DBSTR("OnDlgResize, not ready, skip");
		return TRUE;
	}
	MoveControlsHelper	_temp(this);
	
	vector<uint> vnBottomGroup;
	getButtonIDs(vnBottomGroup);
	MultiPaneDlg::OnDlgResize(vnBottomGroup, cx, cy, false, 2, SPACE_BETWEEN_EACH_BTN_GROUP);	
	
	if(m_bFirstTimeResize)
	{
		Control ctrl;
		MultiPaneDlg::OnShowBottomPane(ctrl);	
	}
	OnTopTabChange(m_TopTab);	
		
	Control btnParamHide = GetItem(IDC_PF_HIDE);
	if( btnParamHide && btnParamHide.Visible )
	{
		int nEdge = GetControlGap();
		
		RECT rBtnParamHide;
		GetClientRect(btnParamHide, rBtnParamHide);
		
		RECT rTab;
		GetClientRect(m_TopTab, rTab);
		
		uint width, height;
		width = RECT_WIDTH(rBtnParamHide);
		height = RECT_HEIGHT(rBtnParamHide);
		
		rBtnParamHide.right = rTab.right;// - nEdge;
		rBtnParamHide.left = rBtnParamHide.right - width;
		
		rBtnParamHide.top = rTab.top - nEdge;
		rBtnParamHide.bottom = rBtnParamHide.top + height;
		
		MoveControl(btnParamHide, rBtnParamHide);			
	}
	
	Control combo = GetItem(IDC_PF_COMBO);
	if( combo && combo.Visible )
	{		
		RECT 	rCombo;
		GetClientRect(combo, rCombo);
		
		RECT 	rOK;
		GetControlClientRect(IDOK, rOK);
				
		int nDy = rOK.bottom -rCombo.bottom;
		
		vector<uint> nIDs = {IDC_PF_COMBO, 0};
		MoveControls(nIDs, 0, nDy);
	}
	/// Hong 12/09/08 QA80-12744 PA_PARAMS_DLG_ADD_FUNC_PREVIEW_TABS
	updateBottonTabCtrlSize();
	/// end PA_PARAMS_DLG_ADD_FUNC_PREVIEW_TABS
	m_bFirstTimeResize = false;
	return TRUE;
}

BOOL FitParaDlg::OnInitSize()
{
	return FALSE;
}

BOOL FitParaDlg::OnRestoreSize(DWORD dwSizeInfo)
{
	void * p = (void*)dwSizeInfo;
	DLGSIZEINFO *pSz = (DLGSIZEINFO*)p;

	lstrcpyn(pSz->szDialogName, m_strDlgName, MAXLINE);
		
	SIZE sz;
	GetDlgOptimalSize(sz);
	pSz->top = -1;
	pSz->left = - 1;
	pSz->width = 800;//sz.cx, hard code, temp
	/// Hong 12/11/08 v8.0985 FIX_DLG_INIT_HEIGHT_TOO_SAMLL_AFTER_ADD_FUNC_PREVIEW_TAB
	//pSz->height = 300;//sz.cy
	pSz->height = 500;//sz.cy
	/// end FIX_DLG_INIT_HEIGHT_TOO_SAMLL_AFTER_ADD_FUNC_PREVIEW_TAB
	return TRUE;
}

BOOL FitParaDlg::OnActivePageChange()
{
	Update();
	return TRUE;
}

BOOL FitParaDlg::OnClickOK()
{
	return TRUE;
}

virtual BOOL FitParaDlg::OnAdvanced(Control ctrl)
{
	return FALSE;
}

virtual BOOL FitParaDlg::OnInitParamValue(Control ctrl)
{
	return FALSE;
}	

BOOL FitParaDlg::OnClickFit(Control ctrl)
{	
	bool bEnable = fit();
	EnableFitButton(bEnable);
	
	///Kyle 09/08/08 USE_NEW_NLFSESSION_AND_NLFPARAMSCONTROL_IN_NLFPARAMDLG
	//int nUpdateSetting = PARMAS_SETTING_VALUES;	///Jasmine 05/05/08 UPDATE_PEAK_LABEL_PLOT_AFTER_PEAK_CENTER_PARAM_CHANGE
	int nUpdateSetting = NLPARAMGRIDCOLTYPE_VALUE;
	///End USE_NEW_NLFSESSION_AND_NLFPARAMSCONTROL_IN_NLFPARAMDLG
	updateParameters(false, &nUpdateSetting);
	
	return TRUE;
}

BOOL FitParaDlg::OnClickOneIter(Control ctrl)
{
	bool bEnable = fit(1);
	EnableFitButton(bEnable);
	///Kyle 09/08/08 USE_NEW_NLFSESSION_AND_NLFPARAMSCONTROL_IN_NLFPARAMDLG
	//int nUpdateSetting = PARMAS_SETTING_VALUES;	///Jasmine 05/05/08 UPDATE_PEAK_LABEL_PLOT_AFTER_PEAK_CENTER_PARAM_CHANGE
	int nUpdateSetting = NLPARAMGRIDCOLTYPE_VALUE;
	///End 
	updateParameters(false, &nUpdateSetting);
	
	return TRUE;
}
///Sophy 10/30/08 QA80-12425 CUSTOMIZATION_PARAMETER_TAB
BOOL FitParaDlg::SelTopTab(int nSel, DWORD dw)
{
	m_TopTab.SetCurSel(nSel);
	return OnTopTabChange(m_TopTab);
}

BOOL FitParaDlg::OnShowMenu(UINT nResIDCtrl, int nx, int ny)
{	
	if(IDC_PF_SETTING_TAB == nResIDCtrl)	
	{
		int nSel = m_paramTabs.GetSelFromMousePos(nx, ny, this);
		
		if(m_TopTab.GetCurSel() != nSel)
			SelTopTab(nSel);
		
		m_paramTabs.OnShowMenu(nx, ny, this);
	}
	
	return TRUE;
}
///end CUSTOMIZATION_PARAMETER_TAB
BOOL FitParaDlg::OnCheckAutoInit(Control ctrl)
{
	Button chkAutoInit = GetItem(IDC_PF_AUTO_INIT_CHECK);
	if(NULL != m_pNLFitSession)
	{
		m_pNLFitSession->SetAutoInitParams( chkAutoInit.Check );
		return TRUE;
	}
	return FALSE;
}

///Jasmine 04/18/08 SHOW_CHI_SQ_IN_PA_PARAM_DLG
BOOL FitParaDlg::OnClickChiSQ(Control ctrl)
{
	/// Hong 01/30/08 QA80-10929 IMPLEMENT_NLFIT_BUTTONS
	bool bEnable = fit(0);
	EnableFitButton(bEnable);
	//updateParameters();
	
	return bEnable;
	/// end IMPLEMENT_NLFIT_BUTTONS
}
///End SHOW_CHI_SQ_IN_PA_PARAM_DLG


/// Hong 01/30/08 QA80-10929 IMPLEMENT_NLFIT_BUTTONS
virtual BOOL FitParaDlg::OnClickSimplex(Control ctrl)
{
	return false;
}
/// end IMPLEMENT_NLFIT_BUTTONS

BOOL FitParaDlg::OnClickParamHide(Control ctrl)
{
	//string strNodePre = "P";		///Kyle 09/10/08 USE_NEW_NLFSESSION_AND_NLFPARAMSCONTROL_IN_NLFPARAMDLG
	vector<string> vsParams;
	///Kyle 09/10/08 USE_NEW_NLFSESSION_AND_NLFPARAMSCONTROL_IN_NLFPARAMDLG
	//TreeNode trParameter = m_pGridParas->GetParamTree();
	//vsParams = trParameter.Names.strVals;
	//vsParams.SetSize( getToltalNumParams() );
	m_pNLFitSession->GetNLParamsMngr()->GetColumn(NLPARAMGRIDCOLTYPE_NAME, vsParams);
	///End USE_NEW_NLFSESSION_AND_NLFPARAMSCONTROL_IN_NLFPARAMDLG
	
	// if size is different, may be function is change...so need to reset all items in m_vnParamsHide to 0
	//------ Folger 04/30/08 QA80-11479 ADD_HIDE_BUTTON_FOR_PA
	//if( m_vnParamsHide.GetSize() != vsParams.GetSize() )
	//{
		//m_vnParamsHide.SetSize(vsParams.GetSize());
		//m_vnParamsHide = 0;
	//}
	updateHiddenParamsInfo();
	//------
	
	///Kyle 09/10/08 USE_NEW_NLFSESSION_AND_NLFPARAMSCONTROL_IN_NLFPARAMDLG
	//GETN_TREE(trParamHide)
	//for(int nn = 0;  nn < vsParams.GetSize(); nn++)
	//{
		//string strTagName = strNodePre + (nn+1);
		//TreeNode trN = trParamHide.AddNode(strTagName, TRGP_CHECK);
		//trN.nVal = m_vnParamsHide[nn];
		//trN.SetAttribute(STR_LABEL_ATTRIB, vsParams[nn]);
	//}
	//if( GetNBox(trParamHide, STR_HIDE_PARAMETERS_DIALOG_TITLE, STR_HIDE_PARAMETERS_DIALOG_DESCRIPTION, NULL, NULL) )
	TreeNodeCollection trNs;	
	if( OpenHideParamRowsBox( trNs, m_vnParamsHide, vsParams) )
	///End USE_NEW_NLFSESSION_AND_NLFPARAMSCONTROL_IN_NLFPARAMDLG
	{
		int index = 0;
		//TreeNodeCollection trNs(trParamHide, strNodePre);		///Kyle 09/10/08 USE_NEW_NLFSESSION_AND_NLFPARAMSCONTROL_IN_NLFPARAMDLG
		foreach(TreeNode trN in trNs)
		{
			m_vnParamsHide[index] = trN.nVal;
			index++;
		}
		return customParamRowsShow();
	}
	return true;
}

///Jasmine 10/17/08 QA80-12401 QUICK_SET_ONE_PARAM_VALUE_TO_ALL
BOOL FitParaDlg::OnQuickSetParam(Control ctrl)
{	
	return m_pGridParas->OnQuickSetParam(ctrl);
}
///End QUICK_SET_ONE_PARAM_VALUE_TO_ALL

///Kyle 09/10/08 USE_NEW_NLFSESSION_AND_NLFPARAMSCONTROL_IN_NLFPARAMDLG
/// Hong QA80-12730 v8.0983b IMRPOVE_HIDE_DLG_WITH_HIDE_BY_GROUP
//bool 	FitParaDlg::OpenHideParamRowsBox(TreeNodeCollection & trNs, const vector<int>& vnParamsHide, const vector<string> & vsLabel)
///------ Folger 03/16/09 PARAMETER_HIDDEN_STATUS_SHOULD_BE_UPDATED_AFTER_PEAKS_CHANGED
//bool 	FitParaDlg::OpenHideParamRowsBox(TreeNodeCollection & trNs, const vector<int>& vnParamsHide, const vector<string> & vsLabel, int* pnGroupToShow/* = NULL*/)
bool 	FitParaDlg::OpenHideParamRowsBox(TreeNodeCollection & trNs, const vector<int>& vnParamsHide, const vector<string> & vsLabel, int* pnGroupToShow/* = NULL*/, bool bShowGetNDialog/* = true*/)
///------ End PARAMETER_HIDDEN_STATUS_SHOULD_BE_UPDATED_AFTER_PEAKS_CHANGED
/// end IMRPOVE_HIDE_DLG_WITH_HIDE_BY_GROUP
{
	ASSERT(vsLabel.GetSize()==vnParamsHide.GetSize());
	///------ Folger 01/05/09 v8.0993d REMEMBER_HIDE_GETN_DIALOG_STATUS_IN_PARAMETER_DIALOG
	/*
	string strNodePre = "P";
	GETN_TREE(trParamHide)
	/// Hong QA80-12730 v8.0983b IMRPOVE_HIDE_DLG_WITH_HIDE_BY_GROUP
	if ( NULL != pnGroupToShow )
	{
		vector<int>			vnIndices;
		string				strList("0|1");
		int					nInitVal = 0;
		if ( 0 < m_pNLFitSession->GetNLParamsMngr()->GetGroupIndices(vnIndices) )
		{			
			vector vIndex;
			vIndex = vnIndices;
			nInitVal = vnIndices[0];
			vector_to_str_list(vIndex, strList, true, false);
		}
		//--- Hong, should NOT insert any other GETN variable below
		GETN_COMBO(Group, _L("Shared Group Except"), nInitVal, strList) GETN_CONTROL_OPTION_BOX(FALSE)
		if ( 0 == vnIndices.GetSize() )
			GETN_READ_ONLY
		//---
	}
	/// end IMRPOVE_HIDE_DLG_WITH_HIDE_BY_GROUP
	for(int nn = 0;  nn < vsLabel.GetSize(); nn++)
	{
		string strTagName = strNodePre + (nn+1);
		TreeNode trN = trParamHide.AddNode(strTagName, TRGP_CHECK);
		trN.nVal = vnParamsHide[nn];
		trN.SetAttribute(STR_LABEL_ATTRIB, vsLabel[nn]);
	}
	*/
	string		strNodePre;
	TreeNode	trParamHide = getParamHideTree(vnParamsHide, vsLabel, &strNodePre, NULL == pnGroupToShow ?  false : true);
	///------ End REMEMBER_HIDE_GETN_DIALOG_STATUS_IN_PARAMETER_DIALOG
	//------ Iris 2/05/2009 FIX_HIDE_PARAM_DLG_TITLE_TOO_LONG_TO_DISPLAY
	//if( GetNBox(trParamHide, STR_HIDE_PARAMETERS_DIALOG_TITLE, STR_HIDE_PARAMETERS_DIALOG_DESCRIPTION, NULL, NULL))
	///------ Folger 03/16/09 PARAMETER_HIDDEN_STATUS_SHOULD_BE_UPDATED_AFTER_PEAKS_CHANGED
	//if( GetNBox(trParamHide, STR_HIDE_PARAMETERS_DIALOG_TITLE))
	if( !bShowGetNDialog || GetNBox(trParamHide, STR_HIDE_PARAMETERS_DIALOG_TITLE))
	///------ End PARAMETER_HIDDEN_STATUS_SHOULD_BE_UPDATED_AFTER_PEAKS_CHANGED
	{
		///------ Folger 02/12/09 IMPROVE_HIDE_PARAM_DIALOG_GUI
		//TreeNodeCollection trNsRes(trParamHide, strNodePre);
		TreeNodeCollection trNsRes(trParamHide.HideCheck, strNodePre);
		///------ End IMPROVE_HIDE_PARAM_DIALOG_GUI
		trNs = trNsRes;
		/// Hong QA80-12730 v8.0983b IMRPOVE_HIDE_DLG_WITH_HIDE_BY_GROUP
		if ( pnGroupToShow && trParamHide.Group )
		{
			int				nUseCheck = 0;
			if ( trParamHide.Group.GetAttribute(STR_ATTRIB_DYNACONTROL_USE_CHECK, nUseCheck) && 1 == nUseCheck )
				*pnGroupToShow = trParamHide.Group.nVal;
		}
		/// end IMRPOVE_HIDE_DLG_WITH_HIDE_BY_GROUP
		return true;
	}
	return false;
	
}
//End USE_NEW_NLFSESSION_AND_NLFPARAMSCONTROL_IN_NLFPARAMDLG

//------ Folger 04/29/08 QA80-11479 ADD_HIDE_BUTTON_IN_NANOSIZER
bool	FitParaDlg::accessHiddenParamsInfo(vector<int> &vnParamsHide, bool bLoad)		// true
{
	Page pg = Project.Pages();
	if ( !pg )
		return false;
	
	LPCSTR	lpcszTageName = "ParametersHide";
	
	HWND hwnd;
	Tree trGetN;
	load_GetN_from_page(pg, trGetN, hwnd, STR_STORAGE_NAME);
	
	if( bLoad )
	{
		TreeNode tr = trGetN.GetNode(lpcszTageName);
		if(!tr.IsValid() )
			return false;
		
		vnParamsHide = tr.nVals;
	}
	else
	{
		TreeNode tr = tree_check_get_node(trGetN, lpcszTageName);
		tr.nVals = vnParamsHide;	
		save_GetN_to_page(pg, trGetN,  hwnd, STR_STORAGE_NAME);
	}
	
	return true;
}
//------ End ADD_HIDE_BUTTON_IN_NANOSIZER

//------ Folger 12/04/08 v8.0982b AVOID_HARD_CODED_MININUM_WIDTH_IN_FIT_PRARMETER_DIALOG
void	FitParaDlg::calcMinWidth()
{
	vector<uint>		vnButtonIDs;
	int		nSize = getButtonIDs(vnButtonIDs);
	if ( nSize == 0 )
		return;
	
	RECT	rrRight;
	GetClientRect(GetItem(vnButtonIDs[0]), rrRight);
		
	ArrangeControlsRightLeft(vnButtonIDs, rrRight.right, rrRight.top);
	
	GetClientRect(GetItem(vnButtonIDs[0]), rrRight);
	RECT	rrLeft;
	GetClientRect(GetItem(vnButtonIDs[nSize-1]), rrLeft);
	RECT	rrCombo;
	GetClientRect(GetItem(IDC_PF_COMBO), rrCombo);
	
	m_nMinWidth = rrRight.right - rrLeft.left + RECT_WIDTH(rrCombo) + 200;
}
//------ End AVOID_HARD_CODED_MININUM_WIDTH_IN_FIT_PRARMETER_DIALOG

//------ Folger 04/30/08 QA80-11479 ADD_HIDE_BUTTON_FOR_PA
virtual bool	FitParaDlg::updateHiddenParamsInfo()
{
	int	nTotalParams = getToltalNumParams();
	if ( m_vnParamsHide.GetSize() != nTotalParams )
	{
		m_vnParamsHide.SetSize(nTotalParams);
		m_vnParamsHide = 0;
		return true;
	}
	return false;
}
//------ End QA80-11479 ADD_HIDE_BUTTON_FOR_PA

/// Hong QA80-12730 v8.0983b IMRPOVE_HIDE_DLG_WITH_HIDE_BY_GROUP
//bool	FitParaDlg::customParamRowsShow(bool bUpdateGird)
bool	FitParaDlg::customParamRowsShow(bool bUpdateGird, int* pnGroupToShow/* = NULL*/)
/// end IMRPOVE_HIDE_DLG_WITH_HIDE_BY_GROUP
{
	vector<int> vnAllParamsHides;
	vnAllParamsHides = m_vnParamsHide;
	
	/*int 	nNumDataset = getParameterGroups();
	if( nNumDataset > 1) //multiple datasets
	{
		for(int nData = 1; nData < nNumDataset; nData++)
		{
			vnAllParamsHides.Append(m_vnParamsHide);
		}
	}*/
	
	int nNumReplica = getParameterGroups() - 1;//0;	
	//TreeNode 	trNumReplica = m_NLF.GetAdvancedTreeNode().Fit.Replica.Number;
	//if(trNumReplica)
		//nNumReplica = trNumReplica.nVal;
	int nReplicaOffset = 2;//m_NLF.GetReplicaOffsetFromFDF();
	int nReplicaUnit = getToltalNumParams() - 1;//m_NLF.GetReplicaUnitFromFDF();
	
	// replica
	if(nNumReplica > 0)
	{
		vector<int> vnSub;
		int nBegin = nReplicaOffset-1; // offset is 1
		int nEnd = nBegin + nReplicaUnit - 1;
		m_vnParamsHide.GetSubVector(vnSub, nBegin, nEnd);
		for(int nn = 0; nn < nNumReplica; nn++)
			vnAllParamsHides.Append(vnSub);
	}	
	///Kyle 09/10/08 CHANGE_PROTOTYPE_OF_HIDEPARAMROWS_AND_REMOVE_SETPARAMROWSSHOW
	//m_pGridParas->SetParamRowsShow(vnAllParamsHides);
	//
	//if(bUpdateGird)
		//m_pGridParas->HideParamRows();
	m_vnParamsHide = vnAllParamsHides;
	if(bUpdateGird)
		m_pGridParas->HideParamRows(m_vnParamsHide);
	///End CHANGE_PROTOTYPE_OF_HIDEPARAMROWS_AND_REMOVE_SETPARAMROWSSHOW
	
	return true;
	
}

BOOL FitParaDlg::OnTopTabChange(Control cntrl)
{
	int nSelTab = m_TopTab.GetCurSel();
	
	RECT rTab;
	GetClientRect(m_TopTab, rTab); 
	m_TopTab.AdjustRect(FALSE, &rTab);
	MoveControl(GetItem(IDC_PF_PARA_GRID), rTab);
	
	if(nSelTab == m_nSelTab)
		return TRUE;
	m_nSelTab = nSelTab;
	//set content
	switch(nSelTab)
	{
	case PF_PARAMETERS_TAB:	
	case PF_PARABOUND_TAB:
		int nShowColType = PF_PARAMETERS_TAB == nSelTab? GROUP_NORMAL : GROUP_BOUNDS;
	///Kyle 09/05/08 USE_NEW_NLFSESSION_AND_NLFPARAMSCONTROL_IN_NLFPARAMDLG
		//m_pGridParas->ChangShowCol(nShowColType);
		///Sophy 10/30/08 QA80-12425 CUSTOMIZATION_PARAMETER_TAB
		//m_pGridParas->SetShowCols(nShowColType);
	default:
		m_paramTabs.ShowTabCols();
		customParamRowsShow();
		///end CUSTOMIZATION_PARAMETER_TAB
	///End USE_NEW_NLFSESSION_AND_NLFPARAMSCONTROL_IN_NLFPARAMDLG
		break;
	}
	return TRUE;	
}

/// Hong 12/09/08 QA80-12744 PA_PARAMS_DLG_ADD_FUNC_PREVIEW_TABS
BOOL 	FitParaDlg::OnBottomTabChange(Control cntrl)
{
	SetFocus(cntrl.GetSafeHwnd());
	setBottomPaneActiveTab();	
	return TRUE;
}

// virtual
void 	FitParaDlg::OnAfterSelChange(Control cntrl, int nOldRowSel, int nOldColSel, int nNewRowSel, int nNewColSel)
{
	///------ Folger 12/15/08 v8.0986c PARAMETER_GRID_RUNTIME_ERROR_WHEN_CHANGE_FIX_STATUS_THEN_FIT
	//if ( nOldRowSel == nNewRowSel )
	if ( nOldRowSel == nNewRowSel || m_pGridParas->GetNumRows() == 0 )
	///------ End PARAMETER_GRID_RUNTIME_ERROR_WHEN_CHANGE_FIX_STATUS_THEN_FIT
		return ;
	
	string		strOldFuncName = m_pGridParas->GetCell(nOldRowSel, NLPARAMGRIDCOLTYPE_FUNC_NAME);
	string		strCurrFuncName = m_pGridParas->GetCell(nNewRowSel, NLPARAMGRIDCOLTYPE_FUNC_NAME);
	if ( 0 != strOldFuncName.Compare(strCurrFuncName) )
		updateBottomTabDisplay();
}

void 	FitParaDlg::setBottomPaneActiveTab(int nTabToShow/* = -1*/)
{
	if ( nTabToShow != -1 )
		m_BottomTab.SetCurSel(nTabToShow);
	
	updateBottomPaneSubControlsShowStatus();
	updateBottomTabDisplay();
}

void	FitParaDlg::updateBottomPaneSubControlsShowStatus()
{
	updateBottonTabCtrlSize();
		
	bool	bShowMessageBox = false, bShowFuncPreviewBox = false, bShowSampleCurveBox = false, bShowFuncFile = false;
	switch ( m_BottomTab.GetCurSel() )
	{
	case PF_MESSAGES:
		bShowMessageBox = true;
		break;
	case PF_FORMULA_TAB:
		bShowFuncPreviewBox = true;
		break;
	case PF_SAMPLE_CURVE_TAB:
		bShowSampleCurveBox = true;
		break;	
	case PF_FUNCTION_FILE_TAB:
		bShowFuncFile = true;
		break;
	default:
		ASSERT(FALSE);
		break;
	}
	GetItem(IDC_PF_OPERATION_LOG).Visible = bShowMessageBox;
	m_NFunctionPrev.SetVisible(bShowFuncPreviewBox);
	m_NCurvePrev.SetVisible(bShowSampleCurveBox);	
	m_reditFunctionFile.Visible = bShowFuncFile;
}

void 	FitParaDlg::updateBottonTabCtrlSize()
{	
	vector<uint> 	vnControls;
	int 			nSelTab = GetBottomPaneSubControls(vnControls);
	if ( nSelTab < vnControls.GetSize() )
	{
		RECT		rDlg, rButton, rBottomTab;
		m_wndDlg.GetClientRect(&rDlg);
		GetClientRect(GetItem(IDOK), rButton);
		GetClientRect(m_BottomTab, rBottomTab);
		
		rBottomTab.top = rButton.bottom + GetControlGap();
		MoveControl(m_BottomTab, rBottomTab);
		m_BottomTab.AdjustRect(FALSE, &rBottomTab);
		
		Control 	ctrl = GetItem( vnControls[nSelTab] );
		MoveControl(ctrl, rBottomTab);
	}
}

void 	FitParaDlg::updateBottomTabDisplay(int nTabToUpdate/* = -1*/)
{
	if ( !IsBottomPaneShown() )
		return ;
	
	int			nSelTab = m_BottomTab.GetCurSel();
	if ( nTabToUpdate != -1 && nTabToUpdate != nSelTab )
		return ;
	
	string		strFuncName;
	Tree		trFDF;
	NLFunctionList	nlFuncList;
	if ( PF_MESSAGES != nSelTab )
	{		
		int			nRow = m_pGridParas->GetSelectedRow();
		if ( -1 != nRow && nRow >= m_pGridParas->GetRowOffset() )
		{		
			strFuncName = m_pGridParas->GetCell(nRow, NLPARAMGRIDCOLTYPE_FUNC_NAME);
			string		strCategoryName;
			nlFuncList.LoadEx(trFDF, strFuncName, strCategoryName);
		}		
	}
	
	switch( nSelTab )
	{
	case PF_MESSAGES:
		// Nothing to do, as it's realtime updated
		break;
	case PF_FORMULA_TAB:		
		m_NFunctionPrev.LoadNLSFFunctionPreview(trFDF, true);
		break;
	case PF_SAMPLE_CURVE_TAB:		
		m_NCurvePrev.LoadNLSFFunctionPreview(trFDF, false);
		break;	
	case PF_FUNCTION_FILE_TAB:		
		m_reditFunctionFile.Reset();
		m_reditFunctionFile.Load(nlFuncList.GetFuncFileName(trFDF, true));
		break;
	default:
		ASSERT(FALSE);
		out_str("Error, nTab not a valid tab");
		break;
	}	
}
/// end PA_PARAMS_DLG_ADD_FUNC_PREVIEW_TABS

///------ Folger 01/05/09 v8.0993d REMEMBER_HIDE_GETN_DIALOG_STATUS_IN_PARAMETER_DIALOG
/// virtual
TreeNode	FitParaDlg::getParamHideTree(const vector<int>& vnParamsHide, const vector<string> & vsLabel, string* pstrNodePre/* = NULL*/, bool bAddGroupShowCombo/* = false*/)
{
	string strNodePre = "P";
	if ( pstrNodePre )
		*pstrNodePre = strNodePre;
	
	if ( m_trParamHide.IsEmpty() )
	{
		TreeNode trParam = m_trParamHide.AddNode();
		///------ Folger 04/20/09 F1_HELP_MAPPING_ON_HIDE_PARAM_DIALOG_IN_NLFIT_AND_PA
		if ( bAddGroupShowCombo )		/// comes from PA
			trParam.SetAttribute(STR_HELPID_ATTRIB, IDD_PAFIT_HIDE_PARAM);
		///------ End F1_HELP_MAPPING_ON_HIDE_PARAM_DIALOG_IN_NLFIT_AND_PA
		
		/// Iris 2/05/2009 FIX_HIDE_PARAM_DLG_TITLE_TOO_LONG_TO_DISPLAY
		GETN_USE(trParam)
		//GETN_STR(Hint, "", STR_HIDE_PARAMETERS_DIALOG_DESCRIPTION) GETN_INFO		///------ Folger 02/12/09 IMPROVE_HIDE_PARAM_DIALOG_GUI
		///end FIX_HIDE_PARAM_DLG_TITLE_TOO_LONG_TO_DISPLAY
		
		///------ Folger 02/12/09 IMPROVE_HIDE_PARAM_DIALOG_GUI
		GETN_BEGIN_BRANCH(HideCheck, STR_HIDE_PARAMETERS_DIALOG_DESCRIPTION)		SET_BRANCH_CTRL_ATTRIBUTES(BCA_NO_CLOSE)
		///------ End IMPROVE_HIDE_PARAM_DIALOG_GUI
		
		for(int nn = 0;  nn < vsLabel.GetSize(); nn++)
		{
			string strTagName = strNodePre + (nn+1);
			///------ Folger 02/12/09 IMPROVE_HIDE_PARAM_DIALOG_GUI
			//TreeNode trN = trParam.AddNode(strTagName, TRGP_CHECK);
			TreeNode trN = trParam.HideCheck.AddNode(strTagName, TRGP_CHECK);
			///------ End IMPROVE_HIDE_PARAM_DIALOG_GUI
			trN.nVal = vnParamsHide[nn];
			trN.SetAttribute(STR_LABEL_ATTRIB, vsLabel[nn]);
		}
		
		///------ Folger 02/12/09 IMPROVE_HIDE_PARAM_DIALOG_GUI
		GETN_END_BRANCH(HideCheck)
		
		GETN_SEPARATOR_LINE
		///------ End IMPROVE_HIDE_PARAM_DIALOG_GUI
		
		if ( bAddGroupShowCombo )
		{
			updateGroupShowCombo(trParam);
		}
	}
	else
	{
		if ( bAddGroupShowCombo )
		{
			updateGroupShowCombo(m_trParamHide.FirstNode);
		}
	}
	
	return m_trParamHide.FirstNode;
}

void		FitParaDlg::updateGroupShowCombo(TreeNode& tr)
{
	vector<int>			vnIndices;
	string				strList("0|1");
	int					nInitVal = 0;
	if ( 0 < m_pNLFitSession->GetNLParamsMngr()->GetGroupIndices(vnIndices) )
	{			
		vector vIndex;
		vIndex = vnIndices;
		nInitVal = vnIndices[0];
		vector_to_str_list(vIndex, strList, true, false);
	}
	if ( tr.Group )
	{
		tr.Group.SetAttribute(STR_COMBO_ATTRIB, strList);
		vector<uint>	vnIndicesTmp;
		if ( vnIndices.Find(vnIndicesTmp, tr.Group.nVal) <= 0 )
			tr.Group.nVal = nInitVal;
	}
	else
	{
		GETN_USE(tr)
		GETN_COMBO(Group, _L("Hide Parameters Except Shared in"), nInitVal, strList) GETN_CONTROL_OPTION_BOX(FALSE)
	}
	tr.Group.Enable = 0 == vnIndices.GetSize() ? false : true;		
}
///------ End REMEMBER_HIDE_GETN_DIALOG_STATUS_IN_PARAMETER_DIALOG

///------ Folger 07/14/09 NANOSIZER_FAILS_TO_UPDATE_PARAMETERS_HIDE_GUI_AFTER_CHANGE_FUNCTION
/// virtual
void	FitParaDlg::ResetParamHideTree()
{
	m_trParamHide.Reset();
}
///------ End NANOSIZER_FAILS_TO_UPDATE_PARAMETERS_HIDE_GUI_AFTER_CHANGE_FUNCTION

void FitParaDlg::OnBeforeEditParaControl(Control flxControl, long nRow, long nCol, BOOL* pCancel)
{
	m_pGridParas->OnBeforeEditParaControl(flxControl, nRow, nCol,pCancel );
}

virtual void FitParaDlg::OnAfterEditParaControl(Control flxControl, int nRow, int nCol)
{	
	m_nParamEditBits = m_pGridParas->OnAfterEdit(flxControl, nRow, nCol);
	/// Hong QA80-12730 v8.0983b IMRPOVE_HIDE_DLG_WITH_HIDE_BY_GROUP
	if ( NLPARAMGRIDCOLTYPE_NAME == nRow )
		updateBottomTabDisplay();
	/// end IMRPOVE_HIDE_DLG_WITH_HIDE_BY_GROUP
	if ( m_nParamEditBits & NLDLGPART_FIT_CONTROL_BTNS )
	{
		EnableFitButton(true);
	}
	/// Hong QA80-12730 v8.0983b IMRPOVE_HIDE_DLG_WITH_HIDE_BY_GROUP
	if ( NLDLGPART_PARAMETERS_GRID & m_nParamEditBits || NLDLGPART_PARAMETERS_BOUNDS_GRID & m_nParamEditBits )
		m_pGridParas->SetupColumnValues();
	/// end IMRPOVE_HIDE_DLG_WITH_HIDE_BY_GROUP
	/// Iris 9/05/2008 PA_PARAM_DLG_USE_NEW_FIT_CLASS
	if(NLPARAMGRIDCOLTYPE_FUNC_NAME != nCol)
		m_pNLFitSession->NotifyParameterChangedByEdit();
	///end PA_PARAM_DLG_USE_NEW_FIT_CLASS		
	/// Iris/Kyle 09/05/08 USE_NEW_NLFSESSION_AND_NLFPARAMSCONTROL_IN_NLFPARAMDLG, m_pGridParas will call parameter manager pointer to real time update param.
	/*
	TreeNode trPara = GetParameterTreeFromGrid();
	if(NULL != m_pNLFitSession)
		m_pNLFitSession->SetParams(trPara);//if change param in grid, dlg need update change to nlfitsession
	*/
	///end USE_NEW_NLFSESSION_AND_NLFPARAMSCONTROL_IN_NLFPARAMDLG
}

void FitParaDlg::OnBeforeMouseDownParaControl(Control cntrl, short nButton, short nShift, float X, float Y, BOOL* pCancel)
{
	/// Hong 12/10/08 v8.0984d ADD_APPLY_TO_ALL_FOR_SIGNIFICANT_DIGITS
	//m_pGridParas->OnBeforeMouseDown(cntrl, nButton, nShift, X, Y, pCancel);
	if ( m_pGridParas->IsMouseOnHeader() )
		m_pGridParas->OnBeforeMouseDown(cntrl, nButton, nShift, X, Y, pCancel);
	else if( nButton == MK_RBUTTON )
	{
		int nRow, nCol, nX, nY;
		m_pGridParas->GetMousePixel( X, Y, nRow, nCol, nX, nY );
		/// Hong 01/21/09 USING_CONTEXT_MENU_APPLY_TO_ALL_TO_REPLACE_QUICK_SET_BTN
		/*
		if ( NLPARAMGRIDCOLTYPE_SD == nCol )
		{
			vector<string>	vsItem;
			vector<byte>  	vbShow;
			vector<bool>	vbDisable;
			vsItem.Add( _L("Apply Digits Setting to All") );
			vbShow.Add(false);
			vbDisable.Add(false);		
			CheckMenu 	MyMenu( vbShow, vsItem, vbDisable );
			int nChoice = MyMenu.DoTrackPopup( nX, nY, m_pGridParas->GetDlgSafeHwnd() );
			if( nChoice >= 0 )
			{			
				if ( 0 == nChoice )
				{
					m_pGridParas->ApplyToAll(nRow, nCol);
					OnAfterEditParaControl(cntrl, nRow, nCol);
				}			
			}
		}
		*/
		vector<string>	vsItem;
		vector<byte>  	vbShow;
		vector<bool>	vbDisable;
		vector<int>		vnChoice;
		/// Hong 01/22/09 NO_APPLY_TO_ALL_IF_SINGLE_SET_NO_REPLICA_IN_NLFIT
		//if ( m_pGridParas->GetItemContextMenu(nRow, nCol, vsItem, vbShow, vbDisable, vnChoice) > 0 )
		DWORD			dwCntrl = 0;		
		if ( m_pNLFitSession && (m_pNLFitSession->GetNumDataset() < 2 && m_pNLFitSession->GetNumPeaks() < 2) )
			dwCntrl |= CM_CNTRL_NO_APPLT_TO_ALL;
		if ( m_pGridParas->GetItemContextMenu(nRow, nCol, vsItem, vbShow, vbDisable, vnChoice, dwCntrl) > 0 )
		/// end NO_APPLY_TO_ALL_IF_SINGLE_SET_NO_REPLICA_IN_NLFIT
		{
			CheckMenu 	MyMenu( vbShow, vsItem, vbDisable );
			int nChoice = MyMenu.DoTrackPopup( nX, nY, m_pGridParas->GetDlgSafeHwnd() );
			if( nChoice >= 0 )
			{			
				ASSERT(nChoice < vnChoice.GetSize());
				///------ Folger 03/05/09 CHANGE_SIGNIFICANT_DIGITS_MAKE_OUTPUT_VALUES_MISSING
				//m_pGridParas->OnItemContextMenu(nRow, nCol, vnChoice[nChoice]);			
				updateOnParameterChange(m_pGridParas->OnItemContextMenu(nRow, nCol, vnChoice[nChoice]));
				///------ End CHANGE_SIGNIFICANT_DIGITS_MAKE_OUTPUT_VALUES_MISSING
			}
		}
		/// end USING_CONTEXT_MENU_APPLY_TO_ALL_TO_REPLACE_QUICK_SET_BTN
	}
	/// end ADD_APPLY_TO_ALL_FOR_SIGNIFICANT_DIGITS
}

void FitParaDlg::OnMouseMoveParaControl(Control cntrl, short nButton, short nShift, float X, float Y)
{
	///Kyle 09/05/08 USE_NEW_NLFSESSION_AND_NLFPARAMSCONTROL_IN_NLFPARAMDLG
	//m_pGridParas->OnMouseMove(cntrl, nButton, nShift, X, Y);   ///  it seems no need to call the function
	///Kyle 01/23/2009 SHOW_TOOLTIP_WHEN_MOUSE_MOVED_ON_BOUNDS_CONTROL
	//_NLF_81("OnMouseMove(cntrl, nButton, nShift, X, Y)");
	m_pGridParas->OnMouseMove(cntrl, nButton, nShift, X, Y);
	///End SHOW_TOOLTIP_WHEN_MOUSE_MOVED_ON_BOUNDS_CONTROL
	///End USE_NEW_NLFSESSION_AND_NLFPARAMSCONTROL_IN_NLFPARAMDLG
}

void FitParaDlg::OnGridComboCloseUp(Control ctrl, int nRow, int nCol, BOOL* pFinishEdit)
{
	switch(nCol)
	{
		///
	//case GRID_COL_PEAK_TYPE:
	//case GRID_COL_SIGN_DIGITES:
	case NLPARAMGRIDCOLTYPE_FUNC_NAME:
	case NLPARAMGRIDCOLTYPE_SD:
		///
		*pFinishEdit = true;
		return;		
	}
}

//------ Folger 12/11/08 v8.0985 SUPPORT_DOUBLE_CLICK_TO_SWICH_BOUND_CONTROL
/*
/// Kyle 09/08/08 USE_NEW_NLFSESSION_AND_NLFPARAMSCONTROL_IN_NLFPARAMDLG
void FitParaDlg::OnGridButtonClick(Control flxControl, int nRow, int nCol)
{
	m_pGridParas->OnButtonClick( flxControl, nRow, nCol );
	//------ Folger 11/15/08 CLICK_GRID_BUTTON_ON_BOUNDS_SHOULD_INVOKE_AFTER_EDIT
	if( NLPARAMGRIDCOLTYPE_LB_CONTROL == nCol || NLPARAMGRIDCOLTYPE_UB_CONTROL == nCol )
		OnAfterEditParaControl( flxControl, nRow, nCol );
	//------
}
///End USE_NEW_NLFSESSION_AND_NLFPARAMSCONTROL_IN_NLFPARAMDLG
*/
void FitParaDlg::OnGridDBClick(Control flxControl)
{
	int nRow = 0, nCol = 0;
	int nx = -1, ny = -1;
	m_pGridParas->GetSelCell(nx, ny, nRow, nCol);
	if( NLPARAMGRIDCOLTYPE_LB_CONTROL == nCol || NLPARAMGRIDCOLTYPE_UB_CONTROL == nCol )
	{
		m_pGridParas->OnButtonClick( flxControl, nRow, nCol );
		OnAfterEditParaControl( flxControl, nRow, nCol )
	}
}
//------ End SUPPORT_DOUBLE_CLICK_TO_SWICH_BOUND_CONTROL

bool FitParaDlg::UpdateFitSession()
{
	if(NULL == m_pNLFitSession)
		return false;
	bool bEnable = true;
	///Kyle 09/05/08
	//m_pNLFitSession->Init(&m_OPMsgLog, false); //here should not init, should fix it later 
	/// Iris 9/05/2008 PA_PARAM_DLG_USE_NEW_FIT_CLASS
	//m_pNLFitSession->InitMsgLog(&m_OPMsgLog);
	///end PA_PARAM_DLG_USE_NEW_FIT_CLASS
	///End 
	//TreeNode trParams = getParamsSetting();
	//if(trParams && !m_pNLFitSession->SetParams(trParams))
		//bEnable = error_report("SetParams fails in UpdateFitSession");
	
	//m_pNLFitSession->UpdateParameterToTree();		///Kyle 09/10/08 CLEAN_CODE_TO_USE_NEW_STYLE
	
	bool bChiSqrReady;
	if(bEnable)
		bEnable = m_pNLFitSession->IsReadyIterations(&bChiSqrReady);	
	EnableFitButton(bEnable); 
	
	return true;
}
//virtual 
void FitParaDlg::EnableFitButton(bool bEnable)
{
	return;
}
///Sophy 12/2/2008 v8.981b UPDATE_OK_BUTTON_AND_RELATIVE_FIT_BUTTONS_ON_ERROR
//virtual
void FitParaDlg::EnableOKButton(bool bEnable)
{
	vector<uint>	vnButtonIDs;
	int nNumButtons = getButtonIDs(vnButtonIDs);
	if( bEnable )
	{
		if( m_vbButtonOldStatus.GetSize() == 0 ) //init, no need to keep enable state of all buttons
			return;
		else //enable buttons after disable them
		{
			ASSERT( nNumButtons == m_vbButtonOldStatus.GetSize() );
			if( nNumButtons != m_vbButtonOldStatus.GetSize() )
			{
				error_report("Number of Button is not as Number of Button status!!");
				return;
			}
			for( int ii = 0; ii < nNumButtons; ii++ )
			{
				Control ctrl = GetItem(vnButtonIDs[ii]);
				if( ctrl )
					ctrl.Enable = m_vbButtonOldStatus[ii];
			}
			m_vbButtonOldStatus.SetSize(0); //after restore, should reset it
		}
	}
	else
	{
		if( m_vbButtonOldStatus.GetSize() > 0 )
			return;
		
		for( int ii = 0; ii < nNumButtons; ii++ )
		{
			Control ctrl = GetItem(vnButtonIDs[ii]);
			if(ctrl)
			{
				m_vbButtonOldStatus.Add(ctrl.Enable);
				ctrl.Enable = bEnable;
			}
			else
				m_vbButtonOldStatus.Add(false); //keep corresponding buttong status, say exists some invalid control
		}
	}
	return;
}
///end UPDATE_OK_BUTTON_AND_RELATIVE_FIT_BUTTONS_ON_ERROR

/// Iris/Kyle 09/05/08 USE_NEW_NLFSESSION_AND_NLFPARAMSCONTROL_IN_NLFPARAMDLG, m_pGridParas will call parameter manager pointer to real time update param.
//bool FitParaDlg::SetFitSession(NLFitSession* pFitSession)
bool FitParaDlg::SetFitSession(NLFitSession* pFitSession)
///end USE_NEW_NLFSESSION_AND_NLFPARAMSCONTROL_IN_NLFPARAMDLG
{
	if(NULL != m_pNLFitSession)
		return true;
	if(NULL == pFitSession)
		return error_report("pFitSession is NULL");
	m_pNLFitSession = pFitSession;
	m_pNLFitSession->InitMsgLog(&m_OPMsgLog);
	return true;
}
bool FitParaDlg::SetAdvTree(TreeNode& tr)
{
	//code here
	return false;
}
bool FitParaDlg::GetAdvTree(TreeNode& tr)
{
	//code here
	return false;	
}
//virtual
bool FitParaDlg::Update(bool bNewGrid)// = false	
{
	return false;
}

//bool FitParaDlg::SetParameterTree(TreeNode& trPara)
//{
	//if(!trPara)
		//return false;	
	////m_pGridParas->LinkFunctionTreeToFitFunction(trPara, true);
	//m_pGridParas->LinkFunctionTreeToFitFunction(trPara, IsShowPeakTypeCol()); /// Hong 02/01/08 8.0798 LT_NLFIT_PARA_NO_NEED_PEAK_TYPE_COLUMN
	//return true;
//}

/// Hong 02/01/08 8.0798 LT_NLFIT_PARA_NO_NEED_PEAK_TYPE_COLUMN
// virtual
bool FitParaDlg::IsShowPeakTypeCol()
{
	return true;
}
/// end LT_NLFIT_PARA_NO_NEED_PEAK_TYPE_COLUMN

///Kyle 09/10/08 CLEAN_CODE_TO_USE_NEW_STYLE
//TreeNode FitParaDlg::GetParameterTreeFromGrid()
//{
	//return m_pGridParas->GetParamTree();
//}
///End CLEAN_CODE_TO_USE_NEW_STYLE

/// Iris 9/05/2008 PA_PARAM_DLG_USE_NEW_FIT_CLASS, no need since will not pass parameter by tree any more
/*
//virtual
bool FitParaDlg::setParameterTreeToGrid()
{
	///Kyle 09/05/08
	//TreeNode trPara = m_pNLFitSession->GetSessionTree().GetNode(STR_PARAM_SETTING);
	TreeNode trPara = m_pNLFitSession->GetTreeFDF().GetNode(STR_PARAM_SETTING);
	///End 
	
	m_pGridParas->LinkFunctionTreeToFitFunction(trPara, true);	
	return true;
}
*/
///end PA_PARAM_DLG_USE_NEW_FIT_CLASS

//virtual 
bool FitParaDlg::updateParameters(bool bNewGrid, int* pnSetting)// = false, NULL
{
	if(NULL == m_pNLFitSession)
		return false;
	
	/// Iris 9/05/2008 PA_PARAM_DLG_USE_NEW_FIT_CLASS
	/*
	setParameterTreeToGrid(); 
	
	int nParaGroupNum = getParameterGroups();
	//int nParaInFirstFunc = m_pNLFitSession->GetNumParameter();
	int nParaInFirstFunc = getToltalNumParams(); /// Hong 02/01/08 v8.0798 FIX_REPLICA_FAIL_DISPLAY_IN_LT_NLFIT_PARA_DIALOG
	*/
	////end PA_PARAM_DLG_USE_NEW_FIT_CLASS
	
	///Kyle 09/05/08 USE_NEW_NLFSESSION_AND_NLFPARAMSCONTROL_IN_NLFPARAMDLG
	//m_pGridParas->Update(nParaInFirstFunc, bNewGrid? nParaGroupNum : -1);//-1 : not create new grid but only do update
	m_pGridParas->Update(m_pNLFitSession->IsAllowSharing());
	m_pGridParas->HideParamRows(m_vnParamsHide);
	///End USE_NEW_NLFSESSION_AND_NLFPARAMSCONTROL_IN_NLFPARAMDLG
	
	return true;
}

//------ Folger 11/05/08 QA80-12509 v8.0965 SUPPORT_BOTH_PEAKS_SORTING_AND_REORDERING_FOR_MULTIPLE_PEAKS_FITTING
void	FitParaDlg::EnablePeakSortingButton(bool bEnable)
{
	Button btn = GetItem(IDC_PF_SORT_PEAKS);
	btn.Enable = bEnable;
}

void	FitParaDlg::EnablePeakReorderingButton(bool bEnable)
{
	Button btn = GetItem(IDC_PF_REORDER_PEAKS);
	btn.Enable = bEnable;
}
//------ End SUPPORT_BOTH_PEAKS_SORTING_AND_REORDERING_FOR_MULTIPLE_PEAKS_FITTING

/// Hong 12/09/08 QA80-12744 PA_PARAMS_DLG_ADD_FUNC_PREVIEW_TABS
//virtual 
int 	FitParaDlg::GetBottomPaneSubControls(vector<uint>& vnCntrls)
{
	vnCntrls.SetSize(0);
	vnCntrls.Add(IDC_PF_OPERATION_LOG);	
	vnCntrls.Add(IDC_PF_FUNC_FORMULA);
	vnCntrls.Add(IDC_PF_FUNC_CURVE);
	vnCntrls.Add(IDC_PF_FUNC_CODE_SHOW);
	return m_BottomTab.GetCurSel();
}
/// end PA_PARAMS_DLG_ADD_FUNC_PREVIEW_TABS

/// Hong 02/01/08 v8.0798 FIX_REPLICA_FAIL_DISPLAY_IN_LT_NLFIT_PARA_DIALOG
// virtual
int FitParaDlg::getToltalNumParams()
{
	if ( !m_pNLFitSession )
		return 0;
	
	return m_pNLFitSession->GetNumParameter();
}
/// end FIX_REPLICA_FAIL_DISPLAY_IN_LT_NLFIT_PARA_DIALOG
//virtual
int FitParaDlg::getParameterGroups()
{
	return -1;
}
//virtual 
bool FitParaDlg::initParaGrid(int nID, Dialog& dlg, LPCSTR lpcszDlgName)
{
	if(NULL == m_pGridParas)
		return error_report("m_pGridParas is NULL");
	m_pGridParas->Init(nID, dlg, lpcszDlgName);
	return true;
}
//virtual
void FitParaDlg::updateControlsVisibility()
{
	//GetItem(IDCANCEL).Visible = false;	
	vector<uint> vnHideIDs = {IDCANCEL, IDC_PF_AUTO_INIT_CHECK, IDC_PF_HIDE, IDC_PF_COMBO, IDC_PF_FIXED_BASELINE, IDC_PF_FIXED_CENTER, IDC_PF_FIXED_WIDTH, IDC_PF_SHARED_WIDTH, 0};
	for(int ii = 0; vnHideIDs[ii]; ii++)
		GetItem(vnHideIDs[ii]).Visible = false;
}
//virtual 
void FitParaDlg::initButtons()
{
	return;
}
//virtual 
int FitParaDlg::getButtonIDs(vector<uint>& vnButtonIDs)
{
	return -1;
}
//virtual 
int FitParaDlg::getMaxIterationNum()
{
	///------ Folger 03/09/09 PROPER_HANDLE_OF_MAX_NUM_ITERATE_IN_FIT_PARAM_DIALOG
	//return 100;
	return m_pNLFitSession->GetMaxNumIter();
	///------ End PROPER_HANDLE_OF_MAX_NUM_ITERATE_IN_FIT_PARAM_DIALOG
}
//virtual
bool FitParaDlg::beforeIterate()
{
	return false;
}
//virtual
bool FitParaDlg::afterIterate(bool bEnable)
{
	return false;
}

bool FitParaDlg::fit(int nNumFit, int nMethod )
{
	if(NULL == m_pNLFitSession)
		return false;
	
	beforeIterate();
	
	///Kyle 09/05/08	it seems no need to do this anymore
	//if(!m_pNLFitSession->SetParams(GetParameterTreeFromGrid()))
		//return error_report("Fail to do fitting since SetParams fails");
	///End 
	
	int nMaxNumIterations = nNumFit;
	if(nMaxNumIterations < 0)
		nMaxNumIterations = getMaxIterationNum();
	
	/// Hong 01/30/08 QA80-10929 IMPLEMENT_NLFIT_BUTTONS
	//m_pNLFitSession->Iterate(nMaxNumIterations, true);//, NULL, NULL, nMethod);	
	///Kyle 09/05/08
	//if ( FITMETH_LEVENBERG_MARQUARDT == nMethod )
		//m_pNLFitSession->Iterate(nMaxNumIterations, true);//, NULL, NULL, nMethod);	
	//else
		//m_pNLFitSession->SimplexFit(nMaxNumIterations);
	m_pNLFitSession->Iterate(nMaxNumIterations, nMethod, true);
	///End
	/// end IMPLEMENT_NLFIT_BUTTONS
	
	//m_pNLFitSession->UpdatePreviewGraph(); 		/// Kyle 09/05/08 it seems no need to do this anymore
	
	bool bEnable, bChiSqrReady;
	bEnable = m_pNLFitSession->IsReadyIterations(&bChiSqrReady);	
	
	afterIterate(bEnable);
	
	return bEnable;
}
/*
//virtual 
TreeNode FitParaDlg::getParamsSetting() 
{
	TreeNode trJunk;
	return trJunk;
}
*/
#endif// _NL_FITTING_H_
